@extends('theme::layouts.public')
@section('content')

    <div class="pageWrap">

        <div class="contentPageWrap">

            @includeIf('core::layouts.partials.members_sidebar')

            <div class="contentWrap membersWrap">
                @includeIf('core::layouts.partials.session_messages')

                <h3>{{ trans('core::fields.user_details.details') }}</h3>

                <form method="post"
                      action="{{ route('core.member.details.store') }}">
                    {{ csrf_field() }}
                    <fieldset class="memberEditContact">

                        <p>{{ trans('core::text.enter_contact_details') }}</p>

                        <div class="row {{ $errors->has('email') ? 'errorWrap showError' : '' }}">
                            <label for="email">{{ trans('core::fields.email') }}<sup>*</sup></label>
                            <div class="inputWrap">
                                <input type="email"
                                       id="email"
                                       name="email"
                                       value="{{ $user->email }}"
                                       class="text"/>
                                @include('core::layouts.partials.error_message', ['errors' => $errors->get('email')])
                            </div>
                        </div>

                        <div class="row {{ $errors->has('contact_no') ? 'errorWrap showError' : '' }}">
                            <label for="contactNo">{{ trans('core::fields.contact_no') }}</label>
                            <div class="inputWrap">
                                <input type="text"
                                       id="contactNo"
                                       name="contact_no"
                                       value="{{ $user->contact_no }}"
                                       class="text" />
                                @include('core::layouts.partials.error_message', ['errors' => $errors->get('contact_no')])
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>

                        <h6>{{ trans('core::fields.user_details.change_password') }}</h6>
                        <p>{{ trans('core::text.change_password_text') }}</p>
                        <change-password></change-password>
                        @include('core::layouts.partials.error_message', ['errors' => $errors->get('password')])
                    </fieldset>

                    <div class="row" id="changeDetailsSubmit">
                        <input type="hidden" name="action" value="update" />
                        <button type="submit"
                                name="submit['change_details']"
                                class="button rollover">
                            {{ trans('core::fields.user_details.change_details') }} <i class="fa fa-angle-right"></i>
                        </button>
                    </div>
                </form>


                <h3>{{ trans('core::fields.user_details.address_book') }}</h3>
                @if (count($addresses))
                    <table class="alternating">
                        <thead>
                            <tr>
                                <th>{{ trans('core::fields.address.name') }}</th>
                                <th>{{ trans('core::fields.address.default') }}</th>
                                <th>{{ trans('core::fields.address.address1') }}</th>
                                <th>{{ trans('core::fields.address.city') }}</th>
                                <th>{{ trans('core::fields.address.postcode') }}</th>
                                <th colspan="2">{{ trans('core::fields.address.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($addresses as $address)
                                <tr>
                                    <td>{{ $address->name }}</td>
                                    @if(Auth::user()->default_address == $address->id)
                                        <td>
                                            <i class="fa fa-check"></i>
                                        </td>
                                    @else
                                        <td>
                                            <form method="post"
                                                  action="{{ route('core.member.addresses.default', $address->id) }}">
                                                {{ csrf_field() }}
                                                <input name="id" value="{{ $address->id }}" type="hidden">
                                                <button id="set-address-default"
                                                        class="button buttonSmall">{{ trans('core::text.set_as_default') }}</button>
                                            </form>
                                        </td>
                                    @endif
                                    <td>{{ $address->address1 }}</td>
                                    <td>{{ $address->city }}</td>
                                    <td>{{ $address->postcode }}</td>
                                    <td>
                                        <a href="{{ route('core.member.addresses.edit', $address->id) }}"
                                           class="button buttonSmall">{{ trans('core::text.edit') }}</a>
                                    </td>
                                    <td>
                                        <delete action="{{ route('core.member.addresses.destroy', $address->id) }}"
                                                redirect="{{ route('core.member.details.index') }}"
                                                text="{{ trans('core::text.delete') }}"></delete>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
                <div>
                    <a class="button buttonSmall"
                       href="{{ route('core.member.addresses.create') }}">{{ trans('core::text.create_new_address') }}</a>
                </div>
            </div> <!-- .contentWrap.membersWrap -->

        </div> <!-- .contentPageWrap -->

    </div> <!-- .pageWrap -->
@endsection
