<?php
/**
 * Address Controller
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Controllers;

use Auth;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Collection;
use Mtc\Core\Contracts\AddressFinder;
use Mtc\Core\Country;

/**
 * Class Address Controller
 *
 * Manages the User Addresses
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */
class AddressFinderController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return Collection|Response
     */
    public function index(Request $request)
    {
        $query = $request->input('query');

        if (empty($query)) {
            return response('No search query passed', 400);
        }

        try {
            $driver = resolve(AddressFinder::class);
            return $driver->search($query);
        } catch (\Exception $e) {
            return response($e->getMessage(), 400);
        }
    }

    /**
     * List all countries in the database
     *
     * @return Collection
     */
    public function show()
    {
        return Country::getOrderedActiveCountries();
    }

}
