<custom-field-list items-in="{{ $item->items->sortBy('order')->keyBy('order') }}" inline-template v-cloak><div>
    <table class="table table-striped">
        <tbody ref="sortable">
            <tr v-for="(item, index) in items" track-by="index">
                <td class="handle table-middle" v-show="items.length > 1">
                    <i class="glyphicon glyphicon-move"></i>
                </td>
                <td>

                    <input type="hidden"
                        name="list[ids][]"
                        :value="item.id"
                        />

                    <input type="text"
                        name="list[titles][]"
                        v-model="item.title"
                        :placeholder="'Option ' + (index + 1)"
                        class="form-control">
                </td>
                <td width="1" class="text-right table-middle">
                    <button class="btn btn-xs btn-danger"
                        title="Remove"
                        @click.prevent="deleteItem(index)"
                        >&times;</button>
                </td>
            </tr>
        </tbody>
    </table>

    <div class="btn-group">
        <button class="btn btn-primary"
            @click.prevent="addOption()">
            Add New Option
        </button>
        <button class="btn btn-default"
            v-show="items.length > 1"
            @click.prevent="sort()">
            Sort Alphabetically
        </button>
    </div>

</div></custom-field-list>

@include('core::layouts.partials.admin.field_error', ['field' => 'list.ids'])
@include('core::layouts.partials.admin.field_error', ['field' => 'list.titles'])
