<?php

namespace Mtc\Core\Http;

use Illuminate\Auth\Middleware\Authenticate as MiddleWare_Authenticate;
use Illuminate\Auth\Middleware\AuthenticateWithBasicAuth as MiddleWare_AuthenticateWithBasicAuth;
use Illuminate\Auth\Middleware\Authorize as MiddleWare_Authorize;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse as MiddleWare_AddQueuedCookiesToResponse;
use Illuminate\Foundation\Http\Kernel as HttpKernel;
use Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode as MiddleWare_CheckForMaintenanceMode;
use Illuminate\Http\Response;
use Illuminate\Routing\Middleware\SubstituteBindings as MiddleWare_SubstituteBindings;
use Illuminate\Routing\Middleware\ThrottleRequests as MiddleWare_ThrottleRequests;
use Illuminate\Routing\Pipeline;
use Illuminate\Session\Middleware\StartSession as MiddleWare_StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession as MiddleWare_ShareErrorsFromSession;
use Mtc\Core\Http\Middleware\EncryptCookies as MiddleWare_EncryptCookies;
use Mtc\Core\Http\Middleware\RedirectIfAuthenticated as MiddleWare_RedirectIfAuthenticated;
use Mtc\Core\Http\Middleware\VerifyCsrfToken as MiddleWare_VerifyCsrfToken;
use Mtc\Core\Http\Middleware\Permission as MiddleWare_Permission;
use Mtc\Core\Http\Middleware\Role as MiddleWare_Role;
use Mtc\Core\Http\Middleware\Currencies as MiddleWare_Currencies;
use Mtc\Core\Events\HttpNotFoundEvent;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        MiddleWare_CheckForMaintenanceMode::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            MiddleWare_EncryptCookies::class,
            MiddleWare_AddQueuedCookiesToResponse::class,
            MiddleWare_StartSession::class,
            MiddleWare_ShareErrorsFromSession::class,
            MiddleWare_VerifyCsrfToken::class,
            MiddleWare_SubstituteBindings::class,
            MiddleWare_Currencies::class,
        ],

        'api' => [
            'throttle:60,1',
            'bindings',
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'auth'       => MiddleWare_Authenticate::class,
        'auth.basic' => MiddleWare_AuthenticateWithBasicAuth::class,
        'bindings'   => MiddleWare_SubstituteBindings::class,
        'can'        => MiddleWare_Authorize::class,
        'guest'      => MiddleWare_RedirectIfAuthenticated::class,
        'permission' => MiddleWare_Permission::class,
        'role'       => MiddleWare_Role::class,
        'throttle'   => MiddleWare_ThrottleRequests::class,
    ];

    /**
     * Extend the default Laravel request handler.
     * This allows adding in root level routes without conflicting between other routes
     * When a 404 Not found is encountered an event is triggered
     * to check if any functionality wants to step in and fill out the request.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response|mixed
     * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
     */
    public function handle($request)
    {
        // Lets allow the kernel go though its original route to process normal requests
        $result = parent::handle($request);

        /*
         * If the request is returning an exception
         * And this exception has a method getStatusCode that returns a 404 code
         * It means that the request was not matched and we can look at additional logic
         *
         * For example these requests would be Node urls or image size generator
         * These processes don't have hard-defined routes so we must rely on
         * logic that will catch the route
         */
        if ($result->exception !== null
            && method_exists($result->exception, 'getStatusCode')
            && $result->exception->getStatusCode() == 404
        ) {
            // If 404 is encountered check for registered events that add extra functionality
            $route_handlers = event(new HttpNotFoundEvent($request));

            // Filter out any events that returned nothing
            $route_handlers = array_filter($route_handlers);

            // If any route handlers left, use the first in the list
            if (count($route_handlers) > 0) {
                $response_to_return = reset($route_handlers);

                // We need to make sure that returned response is a Response entity
                // So if the response given is not a Response entity we wrap it
                if (!$response_to_return instanceof Response) {
                    $response_to_return = new Response($response_to_return);
                }

                // We need to send this request through the pipeline to ensure
                // that middleware is applied. In the end we simply return the response
                // This way we can ensure that middleware like auth or permission runs etc.
                return (new Pipeline(app()))
                    ->send($request)
                    ->through($this->middleware)
                    ->then(function () use($response_to_return) {
                        return $response_to_return;
                    });
            }
        }
        return $result;
    }

}
