<?php

/**
 * @author Uldis Zvirbulis
 * Version: 04.06.2017
 */

namespace Mtc\Core\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

/**
 * Class Permission. Middleware for handling permissions
 * @package Mtc\Core\Http\Middleware
 */
class Permission
{

    /**
     * Handle an incoming request. Aborts request if user hasn't logged in or doesn't have the permission
     *
     * @param  \Illuminate\Http\Request $request
     * @param  Closure $next
     * @param  $permission
     * @return mixed
     */
    public function handle($request, Closure $next, $permission)
    {
        if (Auth::guest() || !$request->user()->can($permission)) {
            abort(403);
        }

        return $next($request);
    }
}
