<?php

/**
 * @author Uldis Zvirbulis
 * Version: 04.06.2017
 */

namespace Mtc\Core\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

/**
 * Class Role. Middleware for handling roles
 * @package Mtc\Core\Http\Middleware
 */

class Role
{

    /**
     * Handle an incoming request. Aborts request if user hasn't logged in or doesn't have the role
     *
     * @param  \Illuminate\Http\Request $request
     * @param  Closure $next
     * @param  $role
     * @return mixed
     */
    public function handle($request, Closure $next, $role)
    {
        if (Auth::guest() || !$request->user()->hasRole($role)) {
            abort(403);
        }

        return $next($request);
    }
}
