<?php
/**
 * StoreSeoSetting Request
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate an incoming request for storing a seo setting.
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class StoreSeoSetting extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $setting = \Route::input('setting', 0);

        return [
            'key' => empty($setting->id) ? 'required|max:255' : '',
            'value' => 'max:255',
            'description' => 'max:255',
        ];
    }
}
