<?php
/**
 * Class HttpNotFoundEvent
 *
 * @package Mtc\Core\Events
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Events;

use Illuminate\Http\Request;
use Illuminate\Queue\SerializesModels;

/**
 * Class HttpNotFoundEvent
 * Event triggered upon 404 encounter
 * Used to extend the default router
 * with dynamic root level route support
 *
 * @package Mtc\Core\Events
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class HttpNotFoundEvent
{
    use SerializesModels;

    /**
     * @var Request
     */
    public $request;

    /**
     * Create a new event instance.
     *
     * @param  Request  $request
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }
}