<?php
/**
 * Map Custom Fields for Models
 *
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core;

use Mtc\Core\CustomFields\CustomFieldValue;

/**
 * Trait to allow for the connection between a Model and corresponding Node.
 *
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
trait HasCustomFields
{
    /**
     * @var array store custom fields in a private array
     */
    private $custom_field_values = [];

    /**
     * Add a method called custom that allows fetching custom fields for item directly
     *
     * @param string $title
     * @return string
     */
    public function custom($title = '')
    {
        // Make sure we load custom fields if they are not loaded before
        if (empty($this->custom_field_values)) {
            $this->custom_field_values = CustomFieldValue::with('field')
                ->where('node_id', $this->node->id ?? null)
                ->get()
                ->keyBy(function (CustomFieldValue $field_value) {
                    return $field_value->field->title;
                })
                ->map(function (CustomFieldValue $field_value) {
                    return $field_value->value;
                });
        }

        return isset($this->custom_field_values[$title]) ? $this->custom_field_values[$title] : '';
    }
}
