<?php
/**
 * Home controller
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 */

namespace Mtc\Core\Http\Controllers;

use Illuminate\Http\Request;

/**
 * Home controller
 *
 * Homepage controller
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk
 * @version 2017-06-17
 */
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->show_breadcrubs = false;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        return view('core::public.home');
    }

    /**
     * Clear session and go back
     *
     * @param Request $request incoming request
     * @return \Illuminate\Http\RedirectResponse response to go back
     */
    public function clearSession(Request $request)
    {
        $request->session()->flush();
        return redirect()->back();
    }
}
