<?php
/**
 * Address Finder Tests
 *
 * @category Mtc\Core\Tests
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Foundation\Testing\DatabaseTransactions;
use Mtc\Core\AddressFinder\Drivers\RoyalMailAddressFinder;
use Mtc\Core\Contracts\AddressFinder;
use Illuminate\Support\Collection;

/**
 * Address Finder Tests
 *
 * Tests to ensure that the Address Finder functionality works with the current config
 *
 * @category Mtc\Core\Tests
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class AddressFinderTest extends TestCase
{
    use DatabaseTransactions;

    /**
     * Confirm that the current driver for the address finder is correct
     */
    public function testCurrentSearchDriverIsValid()
    {
        $driver = resolve(AddressFinder::class);
        $this->assertInstanceOf(AddressFinder::class, $driver);
    }

    /**
     * Integration level test to confirm you can send a request to address finder
     * and it returns results to site - this allows confirming search isn't broken
     * We're also confirming the JSON structure to ensure that all necessary attributes are present
     */
    public function testIsSearchWorking()
    {
        $this->post(route('findAddress'), [
            'query' => 'dd13ja'
        ])->assertStatus(200)
        ->assertJsonStructure([
            '*' => [
                'id',
                'address1',
                'address2',
                'city',
                'display_address',
                'postcode',
                'state',
                'country',
            ]
        ]);
    }

    /**
     * Integration level test to confirm you can send a request to address finder
     * and it returns results to site - this allows confirming search isn't broken
     */
    public function testSearchFailsWithoutQuery()
    {
        $this->post('/find_address')
            ->assertStatus(400);
    }

    /**
     * Confirm that country API endpoint returns a valid and full response
     */
    public function testCanRetrieveCountryList()
    {
        $this->get(route('listCountries'))
            ->assertStatus(200)
            ->assertJsonStructure([
                '*' => [
                    'name',
                    'has_postcodes',
                    'has_states',
                    'code',
                    'is_eu',
                    'states',
                    'status',
                ]
            ]);
    }

}