@extends('theme::layouts.public')
@section('content')
    <div class="pageWrap">

        <div class="contentPageWrap">

            @includeIf('core::layouts.partials.members_sidebar')

            <div class="contentWrap membersWrap">

                <h2>Hello {{ $user->getFirstName() }}</h2>

                <p>{{ trans('core::text.members_welcome_back') }}</p>

                <div class="memberLinks">
                    @foreach(event('members.dashboard') as $link)

                        <div class="memberLink">
                            <a href="{{ $link['url'] }}">
                                @if (!empty($link['icon']))
                                    <i class="fa {{ $link['icon'] }}"></i>
                                @endif
                                <h6>
                                    {{ $link['title'] }}
                                </h6>
                                <span>{{ $link['subtitle'] ?? '' }}</span>
                            </a>
                        </div> <!-- .memberLink -->
                    @endforeach

                    <div class="memberLink">
                        <a href="{{ url('/logout') }}">
                            <i class="fa fa-sign-out"></i>
                            <h6>
                                {{ trans('core::fields.logout') }}
                            </h6>
                            <span>{{ trans('core::fields.logout') }}</span>
                        </a>
                    </div> <!-- .memberLink -->

                </div> <!-- .memberLinks -->

            </div> <!-- .contentWrap.membersWrap -->

        </div> <!-- .contentPageWrap -->

    </div> <!-- .pageWrap -->
@endsection
