<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RefactorCustomFieldsToEav extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('custom_field_values', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('node_id')->unsigned()->index();
            $table->integer('group_id')->unsigned()->index();
            $table->integer('field_id')->unsigned()->index();
            $table->string('field_name');
            $table->string('value')->nullable()->change();
            $table->text('text_value')->nullable();
            $table->boolean('translatable')->default(0);
            $table->timestamps();

            $table->foreign('group_id')
                ->references('id')
                ->on('custom_groups')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('field_id')
                ->references('id')
                ->on('custom_fields')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('node_id')
                ->references('id')
                ->on('nodes')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->unique(['node_id', 'group_id', 'field_id']);

        });

        Schema::table('custom_groups', function (Blueprint $table) {
            $table->dropUnique('custom_groups_table_name_unique');
            $table->drop('table_name');
        });

        Schema::table('custom_fields', function (Blueprint $table) {
            $table->drop('column_name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('custom_field_values');
    }
}
