<custom-field-group item-in="{{ $item }}" inline-template v-cloak>
    <div>
        <div class="form-group">
            <label for="item_title">
                {{ trans('fields.title') }}
            </label>
            <input type="text"
                   class="form-control"
                   name="item[title]"
                   id="item_title"
                   placeholder="{{ trans('fields.title') }}"
                   value="{{ Request::old('item.title', $item->title) }}"
            >
            @include('core::layouts.partials.admin.field_error', ['field' => 'item.title'])
        </div>

        <div class="form-group">
            <label for="models">
                {{ trans('core::fields.applicable_to') }}
            </label>
            <select name="models"
                    id="models"
                    class="form-control"
                    multiple>
                @foreach ($item->getRegisteredModels() as $model)
                    <option value="{{ $model }}"
                            {{ ! $item->models->where('model', '=', $model)->isEmpty() ? 'selected' : '' }}>
                        {{ class_basename($model) }}
                    </option>
                @endforeach
            </select>
        </div>

        <table class="table table-striped">
            <thead>
            <tr>
                <th>{{ __('fields.title') }}</th>
                <th>{{ __('core::fields.type') }}</th>
                <th>{{ __('core::fields.list') }}</th>
                <th class="text-center">{{ __('core::fields.multiple') }}</th>
                <th class="text-center">{{ __('core::fields.translatable') }}</th>
                <th></th>
            </tr>
            </thead>
            <tbody ref="sortable">
            <tr v-for="(field, index) in item.fields" track-by="$index">
                <td>

                    <input type="hidden"
                           name="fields[ids][]"
                           v-model="field.id">
                    <input type="text"
                           name="fields[title][]"
                           :placeholder="'Field ' + (index + 1)"
                           class="form-control"
                           v-model="field.title">
                </td>
                <td>
                    <select name="fields[type][]" class="form-control" v-model="field.type">
                        <option value="text">Text</option>
                        <option value="text-area">Text Area</option>
                        <option value="dropdown">Dropdown</option>
                        <option value="image">Image</option>
                    </select>
                </td>
                <td>
                    <select name="fields[list_id][]"
                            class="form-control"
                            v-model="field.list_id"
                            v-if="field.type == 'dropdown'">
                        <option value=""></option>
                        <option v-for="list in lists" :value="list.id">
                            @{{ list.title }}
                        </option>
                    </select>
                    <input v-else
                           type="hidden"
                           name="fields[list_id][]"
                           value="">
                </td>
                <td class="text-center">
                    <input type="checkbox"
                           v-model="field.multiple"
                           name="fields[multiple][]"
                           v-if="['dropdown', 'image'].indexOf(field.type) !== -1"
                           value="1"
                           title="{{ trans('fields.multiple') }}">

                    <input type="hidden"
                           v-if="field.multiple != 1"
                           name="fields[multiple][]"
                           value="0">
                </td>
                <td class="text-center">
                    <input type="checkbox"
                           v-model="field.translatable"
                           name="fields[translatable][]"
                           v-if="['text', 'textarea'].indexOf(field.type) !== -1"
                           value="1"
                           title="{{ trans('fields.translatable') }}">

                    <input type="hidden"
                           v-if="field.translatable != 1"
                           name="fields[translatable][]"
                           value="0">
                </td>
                <td width="1" class="text-right table-middle">
                    <button class="btn btn-xs btn-danger"
                            title="Remove"
                            @click.prevent="deleteField(index)"
                    >&times;
                    </button>
                </td>
            </tr>
            </tbody>
        </table>

        <button class="btn btn-default"
                @click.prevent="addField()">
            Add New Field
        </button>

    </div>
</custom-field-group>
