<?php
/**
 * Generate tabs within the admin for ItemBuider pages.
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Admin;

/**
 * Create tabs within pages generated with ItemBuilder
 *
 * @category Mtc\Core\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class Tab implements \Mtc\Core\Contracts\Tab
{
    /**
     * The key to associate with this tab.
     *
     * @var string
     */
    public $key = '';
    /**
     * The title which should be used when displaying the link.
     *
     * @var string
     */
    public $title = '';
    /**
     * The route to the specified resource, pre-generated.
     *
     * @var string
     */
    public $route = '';

    /**
     * Create the new tab
     *
     * @param string $key   The key to associate with this tab.
     * @param string $title The title which should be used when displaying the
     *                      link.
     * @param string $route The route to the specified resource, pre-generated.
     *
     * @return void
     */
    public function __construct($key, $title, $route)
    {
        $this->key = $key;
        $this->title = $title;
        $this->route = $route;
    }

    /**
     * Get the key for the tab.
     *
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Get the title for the tab.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the route/URL for the tab.
     *
     * @return string
     */
    public function getRoute()
    {
        return $this->route;
    }
}
