<?php

namespace Mtc\Core\Auth;

use Carbon\Carbon;

/**
 * Trait UserStats
 * Extends User class to have statistics about users
 *
 * @package Mtc\Shop\Order
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
trait UserStats
{
    /**
     * Fetch number of active users by given time
     *
     * @param Carbon $start
     * @param Carbon $end
     * @return mixed
     */
    public static function customerCountInPeriod(Carbon $start, Carbon $end)
    {
        return static::query()
            ->where('created_at', '>=', $start->format('Y-m-d 00:00:00'))
            ->where('created_at', '<=', $end->format('Y-m-d 23:59:59'))
            ->count();
    }

}