<?php

namespace Mtc\Core\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Mtc\Core\Http\Controllers\Admin\HomeController;

/**
 * This script helps improving admin dashboard stats speed
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CacheAdminStats extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'dashboard:refresh-stats';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Caches dashboard stats';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->flushDashboardCache();
        $this->cacheToday();
        $this->cacheWeek();
        $this->cacheMonth();
    }

    /**
     * Flush cache entries that are tagged with label 'dashboard-stats'
     */
    protected function flushDashboardCache()
    {
        Cache::tags('dashboard-stats')->flush();
    }

    /**
     * Cache the data for Today
     */
    protected function cacheToday()
    {
        $start = Carbon::now();
        $start->hour = $start->minute = $start->second = 0;
        $end = Carbon::now();
        $previous_period_start = (clone $start)->subDay();

        HomeController::getStats($start, $end, $previous_period_start);

    }

    /**
     * Cache the data for last week
     */
    protected function cacheWeek()
    {
        $start = Carbon::now()->subDays(7);
        $end = Carbon::now();
        $previous_period_start = (clone $start)->subDays(7);

        HomeController::getStats($start, $end, $previous_period_start);
    }

    /**
     * Cache the data for last Month
     */
    protected function cacheMonth()
    {
        $start = Carbon::now()->subMonth();
        $end = Carbon::now();
        $previous_period_start = (clone $start)->subMonth();

        HomeController::getStats($start, $end, $previous_period_start);
    }
}