<?php
/**
 * Interface AddressFinder
 *
 * @package Mtc/Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core\Contracts;

use Illuminate\Support\Collection;

/**
 * Interface AddressFinder
 *
 * This interface implements requirements necessary for allowing address finder functionality
 * This allows building elastic approach to search by creating easy way how to
 * add new address finder engines or swap between them.
 *
 * @package Mtc/Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
interface AddressFinder
{
    /**
     * Search for an address
     *
     * @return Collection
     */
    public function search($query);
}