<?php

namespace Mtc\Core\Http\Controllers;

use Creitive\Breadcrumbs\Breadcrumbs;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\View\View;

/**
 * Class Controller
 * @package Mtc\Core\Http\Controllers
 * @property Breadcrumbs $breadcrumbs
 */
class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    /**
     * Controller constructor.
     * We need to extend the base controller to initialize breadcrumbs
     */
    public function __construct()
    {
        $this->breadcrumbs = new Breadcrumbs();
        $this->breadcrumbs->addCrumb(trans('core::text.home'), action('\\' . HomeController::class . '@index'));
        $this->show_breadcrubs = true;
    }

    /**
     * Set a custom callAction method
     * This is done to ensure that breadcrumbs are passed automatically to views
     * We execute the parent callAction and check if breadcrumbs should be added to response
     * before returning response
     *
     * @param string $method
     * @param array $parameters
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function callAction($method, $parameters)
    {
        $result =  parent::callAction($method, $parameters);

        $controller_class = get_class($this);
        event("Controller:{$controller_class}:{$method}", [$parameters, $result]);

        // If result is a View and user has not disabled breadcrumbs for view
        if ($result instanceof View && !empty($this->show_breadcrubs)) {
            $result->with([
                'bread_crumbs' => $this->breadcrumbs->getBreadcrumbs()
            ]);
        }

        // return the response
        return $result;
    }
}
