<?php
/**
 * StoreDefault Request
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Core\Models\Seo\Defaults;

/**
 * Validate an incoming request for storing seo defaults for a node.
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class StoreSeoDefault extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $default = \Route::input('default', 0);
        $default_id = $default->id ?? 0;

        return [
            'name' => 'required|max:255',
            'rule_type' => 'required',
            'node_type' => 'required_if:rule_type,1|unique:seo_defaults,node_type,' . $default_id,
            'path' => 'required_if:rule_type,2|unique:seo_defaults,path,' . $default_id,
            'title' => 'required|max:255',
            'description' => 'required|max:255',
        ];
    }
}
