<?php
/**
 * Class Seo\PageMetaValues
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Models\Seo;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Seo\PageMetaValues
 *
 * Allows setting specific information for pages
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class PageMetaValues extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'seo_page_meta_values';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'url',
        'title',
        'description',
        'h1'
    ];
}
