<?php
/**
 * Royal Mail Address Finder Tests
 *
 * @category Mtc\Core\Tests
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Foundation\Testing\DatabaseTransactions;
use Mtc\Core\AddressFinder\Drivers\RoyalMailAddressFinder;
use Mtc\Core\Contracts\AddressFinder;
use Illuminate\Support\Collection;

/**
 * Royal Mail Address Finder Tests
 *
 * These tests are specific to Royal Mail driver of the Address Finder functionality.
 *
 * @category Mtc\Shop\Tests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class RoyalMailAddressFinderTest extends TestCase
{
    use DatabaseTransactions;

    /**
     * Test to confirm that Royal Mail search engine is an instance of Address finder
     * This way we can confirm that Royal Mail driver is a valid search engine
     */
    public function testIsRoyalMailInstanceOfAddressFinderInterface()
    {
        $royal_mail = new RoyalMailAddressFinder();
        $this->assertInstanceOf(AddressFinder::class, $royal_mail);
    }

    /**
     * Test to confirm that Royal Mail returns an address collection when searching a postcode
     * We're using dd13ja which we know is a valid postcode
     */
    public function testSearchRoyalMailValidPostcode()
    {
        $royal_mail = new RoyalMailAddressFinder();
        $results = $royal_mail->search('dd1 3ja');
        $this->assertInstanceOf(Collection::class, $results);
        $this->assertTrue($results->count() > 0);
    }

    /**
     * Test to confirm that Royal Mail fails on wrong postcode we need provide search with an invalid postcode
     * Test will run correctly if it throws an exception
     */
    public function testSearchRoyalMailInvalidPostcode()
    {
        $this->expectException(\Exception::class);

        $royal_mail = new RoyalMailAddressFinder();
        $royal_mail->search('ddxx1a');
    }

    /**
     * Test to confirm that Royal Mail returns an address collection when searching a partial address string
     * We're using "city quay" which we know is a valid address string
     */
    public function testSearchRoyalMailPartialAddress()
    {
        $this->markTestIncomplete();
        /* TODO: implement search by partial(wildcard) address
        $royal_mail = new RoyalMailAddressFinder();
        $results = $royal_mail->search('city quay');
        $this->assertTrue($results instanceof Collection);
        $this->assertTrue($results->count() > 0);
        */
    }

}