<?php
/**
 * Class AddCouponsTables
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-04-17
 */
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class AddCouponsTables
 *
 * Migration to add coupon table
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-04-17
 */
class AddCouponsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('code')->unique();
            $table->date('date_from')->index();
            $table->date('date_to')->index();
            $table->integer('redemptions')->index();
            $table->enum('type', ['amount_off', 'percent_off'])->index();
            $table->integer('value');
            // Advanced coupon fields
            $table->tinyInteger('allow_multiple_discounts');
            $table->tinyInteger('grant_free_delivery');
            $table->integer('min_basket_amount');
            $table->tinyInteger('only_first_order');
            $table->integer('used_in_basket_count');
            $table->integer('purchase_count');
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('coupon_restrictions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('coupon_id')->index();
            $table->string('restriction_object')->index();
            $table->integer('restriction_id')->index();
            $table->tinyInteger('is_exclude')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
        Schema::dropIfExists('coupon_restrictions');
    }
}
