<?php
/**
 * Public Coupon Controller
 *
 * @package mtc/coupons
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017.05.13
 */

namespace Mtc\Coupons\Http\Controllers;

use Carbon\Carbon;
use Mtc\Core\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Core\Admin\Builder;
use Mtc\Coupons\Models\Coupon;
use Mtc\Coupons\Http\Requests\Admin\StoreCoupon;
use Mtc\Shop\Contracts\BasketContract;

/**
 * Public Coupon Controller
 *
 * This controller is used for managing coupon redemption on basket
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017.05.13
 */
class CouponController extends Controller
{
    public function store(Request $request, BasketContract $basket)
    {
        $validation_result = Coupon::validate($request, $basket);
        if ($validation_result instanceof Coupon) {
            $basket = $validation_result->apply($request, $basket);
            $errors = '';
        } else {
            $errors = $validation_result;
        }

        return [
            'basket' => $basket,
            'errors' => [
                $errors
            ]
        ];

    }

}
