
<h3>{{ trans('coupons::titles.info') }}</h3>
<div class="form-horizontal">

    <div class="form-group">
        <label for="name" class="col-sm-2 control-label">
            {{ trans('fields.name') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                   class="form-control"
                   name="name"
                   id="name"
                   placeholder="{{ trans('fields.name') }}"
                   value="{{ Request::old('name', $item->name) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'name'])
        </div>
    </div>

    <div class="form-group">
        <label for="code" class="col-sm-2 control-label">
            {{ trans('coupons::fields.code') }}
        </label>
        <div class="col-sm-10">
            <input type="text"
                   class="form-control"
                   name="code"
                   id="code"
                   placeholder="{{ trans('coupons.fields.code') }}"
                   value="{{ Request::old('code', $item->code) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'code'])
        </div>
    </div>

    <div class="form-group">
        <label for="date_from" class="col-sm-2 control-label">
            {{ trans('coupons::fields.date_from') }}
        </label>
        <div class="col-sm-10">
            <date-picker date-in="{{ Request::old('date_from', $item->date_from) }}"
                         with-time="false"
                         placeholder="{{ trans('coupons::fields.date_from_placeholder') }}"
                         name="date_from"
            ></date-picker>
            @include('core::layouts.partials.admin.field_error', ['field' => 'date_from'])
        </div>
    </div>

    <div class="form-group">
        <label for="date_to" class="col-sm-2 control-label">
            {{ trans('coupons::fields.date_to') }}
        </label>
        <div class="col-sm-10">

            <date-picker date-in="{{ Request::old('date_to', $item->date_to) }}"
                         placeholder="{{ trans('coupons::fields.date_to_placeholder') }}"
                         with-time="false"
                         name="date_to"
            ></date-picker>
            @include('core::layouts.partials.admin.field_error', ['field' => 'date_to'])
        </div>
    </div>

    <div class="form-group">
        <label for="redemptions" class="col-sm-2 control-label">
            {{ trans('coupons::fields.redemptions') }}
        </label>
        <div class="col-sm-10">
            <input type="number"
                   class="form-control"
                   name="redemptions"
                   id="redemptions"
                   placeholder="{{ trans('# of redemptions, default is 1') }}"
                   value="{{ Request::old('redemptions', $item->redemptions) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'redemptions'])
        </div>
    </div>

    <div class="form-group">
        <label for="type" class="col-sm-2 control-label">
            {{ trans('coupons::fields.type') }}
        </label>
        <div class="col-sm-10">
            <select name="type"
                    id="type"
                    class="form-control">
                @foreach (\Mtc\Coupons\Models\Coupon::$coupon_types as $coupon_type => $coupon_type_name)
                    <option value="{{ $coupon_type }}"
                            {{ Request::old('type', $item->type) == $coupon_type ? 'selected' : '' }}>
                        {{ $coupon_type_name }}
                    </option>
                @endforeach
            </select>
            @include('core::layouts.partials.admin.field_error', ['field' => 'type'])
        </div>
    </div>
    <div class="form-group">
        <label for="value" class="col-sm-2 control-label">
            {{ trans('coupons::fields.value') }}
        </label>
        <div class="col-sm-10">
            <input type="number"
                   class="form-control"
                   name="value"
                   id="value"
                   placeholder="{{ trans('fields.value') }}"
                   value="{{ Request::old('value', $item->value / 100) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'value'])
        </div>
    </div>

    <div class="form-group">
        <label for="min_basket_amount" class="col-sm-2 control-label">
            {{ trans('coupons::fields.min_amount') }}
        </label>
        <div class="col-sm-10">
            <input type="number"
                   class="form-control"
                   name="min_basket_amount"
                   id="min_basket_amount"
                   placeholder="{{ trans('Minimal purchase amount') }}"
                   value="{{ Request::old('min_basket_amount', $item->min_basket_amount / 100) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'min_basket_amount'])
        </div>
    </div>

    <div class="form-group">
        <label for="grant_free_delivery" class="col-sm-2 control-label">
            {{ trans('coupons::fields.free_delivery') }}
        </label>
        <div class="col-sm-10 checkbox">
            <label for="grant_free_delivery_yes">
                <input type="radio"
                       name="grant_free_delivery"
                       id="grant_free_delivery_yes"
                       value="1"
                       {{ Request::old('grant_free_delivery', $item->grant_free_delivery) == 1 ? 'checked' : '' }}
                />
                {{ trans('coupons::fields.yes') }}
            </label>

            <label for="grant_free_delivery_yes">
                <input type="radio"
                       name="grant_free_delivery"
                       id="grant_free_delivery_yes"
                       value="2"
                       {{ Request::old('grant_free_delivery', $item->grant_free_delivery) == 2 ? 'checked' : '' }}
                />
                {{ trans('coupons::fields.only_local') }}
            </label>

            <label for="grant_free_delivery_no">
                <input type="radio"
                       name="grant_free_delivery"
                       id="grant_free_delivery_no"
                       value="0"
                       {{ Request::old('grant_free_delivery', $item->grant_free_delivery) == 0 ? 'checked' : '' }}
                />
                {{ trans('coupons::fields.no') }}
            </label>
            @include('core::layouts.partials.admin.field_error', ['field' => 'grant_free_delivery'])
        </div>
    </div>

    @if (config('coupons.coupons_advanced'))
        <div class="form-group">
            <label for="allow_multiple_discounts" class="col-sm-2 control-label">
                {{ trans('coupons::fields.discount_stacking') }}
            </label>
            <div class="col-sm-10 checkbox">
                <label for="allow_multiple_discounts_yes">
                    <input type="radio"
                           name="allow_multiple_discounts"
                           id="allow_multiple_discounts_yes"
                           value="1"
                           {{ Request::old('allow_multiple_discounts', $item->allow_multiple_discounts) == 1 ? 'checked' : '' }}
                    />
                    {{ trans('coupons::fields.yes') }}
                </label>

                <label for="allow_multiple_discounts_no">
                    <input type="radio"
                           name="allow_multiple_discounts"
                           id="allow_multiple_discounts_no"
                           value="0"
                           {{ Request::old('allow_multiple_discounts', $item->allow_multiple_discounts) == 0 ? 'checked' : '' }}
                    />
                    {{ trans('coupons::fields.no') }}
                </label>
                @include('core::layouts.partials.admin.field_error', ['field' => 'allow_multiple_discounts'])
            </div>
        </div>

        <div class="form-group">
            <label for="only_first_order" class="col-sm-2 control-label">
                {{ trans('coupons::fields.first_order') }}
            </label>
            <div class="col-sm-10 checkbox">
                <label for="only_first_order_yes">
                    <input type="radio"
                           name="only_first_order"
                           id="only_first_order_yes"
                           value="1"
                           {{ Request::old('only_first_order', $item->only_first_order) == 1 ? 'checked' : '' }}
                    />
                    {{ trans('coupons::fields.yes') }}
                </label>

                <label for="only_first_order_no">
                    <input type="radio"
                           name="only_first_order"
                           id="only_first_order_no"
                           value="0"
                           {{ Request::old('only_first_order', $item->only_first_order) == 0 ? 'checked' : '' }}
                    />
                    {{ trans('coupons::fields.no') }}
                </label>
                @include('core::layouts.partials.admin.field_error', ['field' => 'only_first_order'])
            </div>
        </div>
    @endif
</div>

@if (config('coupons.coupons_advanced') && $item->id)
    <h3>{{ trans('coupons::titles.restrictions') }}</h3>
    <coupon-restriction coupon-in="{{ $item }}"
                        restriction-types="{{ json_encode($restriction_types) }}"
                        action="{{ $restriction_action }}"
    ></coupon-restriction>
@endif