<?php
/**
 * StoreCoupon Request
 *
 * @package  Mtc\Coupons
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Coupons\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * StoreCoupon Class
 *
 * Determine that data for a coupon is all valid.
 *
 * @category Mtc\Coupons\Http\Requests\Admin
 * @package  Mtc\Coupons
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class StoreCoupon extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $coupon = \Route::input('coupon', null);
        $value_additional = '';
        if (request()->input('type') === 'percent_off') {
            $value_additional = '|max:100';
        }

        return [
            'name' => 'required|max:255',
            'code' => 'required|max:255|alpha_dash|unique:coupons,code,' . ($coupon ? $coupon->id : 0),
            'redemptions' => 'required|numeric|min:1',
            'type' => 'required',
            'date_from' => 'date',
            'date_to' => 'date',
            'value' => 'required|numeric|min:0.01' . $value_additional,
        ];
    }
}
