<?php
/**
 * Class Coupon\Restriction
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-04-14
 */

namespace Mtc\Coupons\Models\Coupon;

use Illuminate\Database\Eloquent\Model;
use Mtc\Coupons\Models\Coupon;

/**
 * Class Coupon\Restriction
 *
 * Extends Coupon functionality by adding restrictions.
 * These restrictions denote if coupon can be applied to basket items
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-04-14
 */
class Restriction extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'coupon_restrictions';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'coupon_id',
        'restriction_type',
        'restriction_id',
        'is_exclude'
    ];

    /**
     * @var string[] $supported_restrictions List of restriction objects coupons can check
     */
    public static $supported_restrictions = [
        '\Mtc\Shop\Product' => 'Product',
        '\Mtc\Core\Taxonomy' => 'Taxonomy'
    ];

    /**
     * Relationship with Coupon that has this restriction
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function coupon()
    {
        return $this->belongsTo(Coupon::class, 'coupon_id');
    }

    /**
     * Get a list of all owning nodeable models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function restriction()
    {
        return $this->morphTo();
    }

}