@push('pre_scripts')
    <script type="text/javascript" src="{{ route('language_json') }}?{{ app()->getLocale() }}"></script>
@endpush

@if (!empty($enabled_languages) && $enabled_languages->count() > 1)
    <div class="countrySelect">
        <span class="label">
            {{ trans('languages::text.select_language') }}
            <i class="fa fa-angle-down" aria-hidden="true"></i>
        </span>


        <ul class="languageDropdown">
            @foreach ($enabled_languages as $language)
                <li>
                    <a class="selectLink js_popupLangSwitch"
                       href="{{ $language->linkThisPage() }}"
                       data-code="{{ $language->locale_code }}"
                       title="{{ $language->name}}">
                        <span class="countryFlag {{ $language->locale_code }}"></span>
                        <span class="countryName">{{ $language->name }}</span>
                    </a>
                </li>
            @endforeach
        </ul>
    </div> <!-- .countrySelect -->
@endif