<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method.
 *
 * @category Mtc\Components\Languages
 * @package Mtc\Components\Languages
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

/**
 * @var \Illuminate\Routing\Router $router
 */
$router->group([
    'middleware' => 'web'
], function (\Illuminate\Routing\Router $router) {
    $router->get('language_json', LanguageJsonController::class . '@index')->name('language_json');

    $router->group([
        'prefix' => 'admin',
        'middleware' => ['web', 'auth', 'permission:admin'],
        'as' => 'languages.admin.'
    ], function($router) {
        $router->get('languages/{language}/download', Admin\LanguageController::class . '@download')
            ->name('languages.download');
        $router->resource('languages', Admin\LanguageController::class);
    });
});
