
LaraCore multi-language management package. Ensures language management.

## Installation ##

Language package should auto-install as a depencency of mtc/core.

In case it did not auto-install please run the following commands:
```
composer require mtc/menus

php artisan vendor:publish
php artisan migrate
php artisan db:seed --class=LanguageSeeder
```

Assets should auto-compile with the next `npm run` execution

## Usage ##

This package ensures two levels of language management

* Static and Dynamic translation management
* Language creation / deletion

This is managed via two permission levels:
* `manage-languages` - allows enabling/disabling existing languages as well as download and upload static translations
* `add-delete-languages` - allows creating new languages and deleting existing languages. __Avoid giving this permission to admin users if possible__


There are two types of translatable content and both are managed separately

### Static Text Translations ###

Static text is text that is manually added to templates and is not updatable through any Models in DB.
Static translation management goes through admin panel __Manage Languages__ section. In the language edit 
section admin can download current translation collection as a json file. User then opens the file, makes 
adjustments in translations and uploads file. This file updates the list of translations that are shown on site.

__Adding static translations__ 

This should be done by inserting new tags in templates through the following methods
```blade
{{ __('namespace::group.field') }} {{-- Text only output --}}
{!! __('namespace::group.field') !!} {{-- HTML whitelisted output --}}
@trans('namespace::group.field')
```  

By default translation tags (labels) are stored in language .php files that return an array of keys => values for translations.
To ensure it is easier to manage translations from admin this is changed to the JSON model as it allows storing everything 
in a single file. However to ensure the unique labels for translations the tags keep their structure. Translation tag (label) consists of 3 parts
* namespace - this is required for vendor packages, otherwise it is replaced with `app`  - i.e. ``'app::group.field'``
* group - this represents the file in which the translation is saved.
* field - this can be multipart if field it is defined as nested array in file.

### Dynamic content translations ###

Dynamic translations are managed using `spatie/laravel-translatable` package. This package allows converting any 
text field to translatable field as long as it follows these guidelines:
* ``HasTranslatable`` trait is added to model
* ``$public $translatable = []``  property is added to model showing which columns can be translated
* All translatable fields are stored as `TEXT` in database 
* Translatable fields are built using `Mtc\Core\Form` class 

Switching between dynamic translations is done with language switcher in admin dashboard navigation bar. This switcher
only toggles active language so all changes to different languages will save upon form submission.   


## Contribution guidelines ##

* Make sure tests are created and run. PR must include confirmation of all tests passing
* Code review - PSR-1/2 standard


## Who do I talk to? ##

* Check composer.json for listed authors
* mtc senior developers
