@extends('core::layouts.admin')

@section('title',  'Manage ' . ucfirst($title))

@section('content')

    <form method="POST" action="{{ $form_action }}" enctype="multipart/form-data">

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
            >{{ __('core::fields.save') }}
            </button>
        </div>

        @include('core::admin.builder.partials.errors')

        @include('core::admin.builder.partials.tabs')

        <div class="well clearfix">
            <div class="col-lg-4 col-md-8 col-sm-12">
                {!!
                    Mtc\Core\Form::input([
                        'label' => 'fields.name',
                        'field_name' => 'name',
                        'id' => 'name',
                        'name' => 'name',
                        'placeholder' => 'fields.name',
                        'old_value' => 'name',
                        'object' => $item
                    ])
                !!}

                {!!
                    Mtc\Core\Form::input([
                        'label' => 'core::fields.code',
                        'field_name' => 'locale_code',
                        'disabled' => $item->id,
                        'id' => 'locale_code',
                        'name' => 'locale_code',
                        'placeholder' => 'languages::text.locale_code',
                        'old_value' => 'locale_code',
                        'object' => $item
                    ])
                !!}

                {!!
                    Mtc\Core\Form::radio([
                        'label' => 'core::fields.is_active',
                        'field_name' => 'enabled',
                        'id' => 'enabled',
                        'name' => 'enabled',
                        'placeholder' => 'core::fields.enabled',
                        'old_value' => 'enabled',
                        'object' => $item,
                        'values' => [
                            1 => 'core::fields.yes',
                            0 => 'core::fields.no',
                        ]
                    ])
                !!}
            </div>
        </div>

        @if ($item->id)
            <div class="well">
                <h3>{{ __('languages::text.manage_language_file') }}</h3>

                <p>{{ __('languages::text.update_process') }}</p>

                <div class="form-group">
                    <a href="{{ route('languages.admin.languages.download', [$item->id]) }}"
                       class="btn btn-primary">
                        {{ __('languages::text.download') }}
                    </a>
                </div>

                {!!
                    Mtc\Core\Form::file([
                        'id' => "language_file",
                        'name' => "language_file",
                        'old_value' => "language_file",
                        'object' => $item,
                    ])
                !!}
            </div>
        @endif

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
            >{{ __('core::fields.save') }}
            </button>
            <div class="pull-right">
                <a class="btn btn-default" href="#top">{{ __('core::fields.back_to_top') }}</a>
            </div>
        </div>

        {{ method_field($form_method) }}
        {{ csrf_field() }}
    </form>
@endsection
