<?php
namespace Mtc\Components\Languages\Http\Controllers;

use Illuminate\Support\Facades\Cache;
use Mtc\Components\Languages\Language;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Core\Http\Requests;
use Illuminate\Http\Request;

/**
 * Displays the language routes as a resource
 *
 * @category Mtc\Menus\Http\Controllers
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class LanguageJsonController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     */
    public function index(Request $request)
    {
        $translations = [];
        $current_language = app()->getLocale();
        if ($request->input('show_tags') === null) {
            // Load translations and store them in cache for 1 day
            $translations = Cache::remember('translations_' . $current_language, 24 * 60, function () {
                $language = Language::query()
                    ->where('locale_code', app()->getLocale())
                    ->first();
                return $language ? $language->getTranslations() : [];
            });
        }

        if (app()->bound('debugbar')) {
            app('debugbar')->disable();
        }
        return view('languages::public.language_json')->with(compact('translations', 'current_language'));
    }

}
