<?php

use Mtc\Core\Auth\Permission;
use Illuminate\Database\Seeder;
use Mtc\Components\Languages\Language;

class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Seed basic languages if they are not yet set up
        if (Language::query()->count() == 0) {
            collect([
                [
                    'name' => 'English',
                    'locale_code' => 'en',
                    'enabled' => 1,
                ],
                [
                    'name' => 'Latvian',
                    'locale_code' => 'lv',
                    'enabled' => 0,
                ],
            ])->each(function($item) {
                Language::query()
                    ->create($item);
            });
        }

        // Add permissions entry if it is not yet set up
        if (Permission::query()->where('name', 'manage-languages')->count() == 0) {
            $permission = Permission::query()
                ->create([
                    'name' => 'manage-languages',
                    'guard_name' => 'web',
                    'permission_group' => 'management'
                ]);

            /**
             * @var \Mtc\Core\Auth\Role $mtc
             */
            $mtc = \Mtc\Core\Auth\Role::query()->where('name', 'mtc')->first();
            if ($mtc) {
                $mtc->givePermissionTo($permission->name);
            }

            $permission = Permission::query()
                ->create([
                    'name' => 'add-delete-languages',
                    'guard_name' => 'web',
                    'permission_group' => 'management'
                ]);

            /**
             * @var \Mtc\Core\Auth\Role $mtc
             */
            $mtc = \Mtc\Core\Auth\Role::query()->where('name', 'mtc')->first();
            if ($mtc) {
                $mtc->givePermissionTo($permission->name);
            }
        }

    }
}
