<?php
namespace Mtc\Components\Languages\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Mtc\Components\Languages\Language;

/**
 * Class Languages
 *
 * Middleware for setting the correct Language locale on server.
 * This allows displaying the correct locale for models & translations
 *
 * @package Mtc\Components\Languages
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Languages
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  Closure $next
     * @return Closure Next middleware to process
     */
    public function handle($request, Closure $next)
    {
        if ($request->input('view_translation_tags') && Auth::user() && Auth::user()->can('manage-languages')) {
            app()->setLocale('show_tags');
            return $next($request);
        }

        Language::processLanguageFromRequest($request);

        if (!empty(session('language_selected'))) {
            app()->setLocale(session('language_selected'));
        }
        return $next($request);
    }
}
