<?php
namespace Mtc\Components\Languages\Http\ViewComposers;

use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;
use Mtc\Components\Languages\Language;

/**
 * Display any data required for products to a view.
 *
 * @category Mtc\Shop\Http\ViewComposers
 * @package  Mtc\Shop
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class LanguageComposer
{
    /**
     * Return information about the price methods available to choose from
     * for a product.
     *
     * @param View $view Source View
     *
     * @return void
     */
    public function compose(View $view)
    {
        $only_codes = stripos($view->getName(), 'language_switcher') === false;
        $cache_name = 'enabled_languages_' . ($only_codes ? 'codes' : 'full');
        $enabled_languages = Cache::remember($cache_name, 60, function () use ($only_codes) {
            if ($only_codes) {
                return Language::query()->enabled()->pluck('locale_code');
            }
            return Language::query()->enabled()->get();

            });

        $view->with([
            'enabled_languages' => $enabled_languages,
            'current_language' => app()->getLocale()

        ]);
    }
}
