<?php
namespace Mtc\Components\Languages\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\View;
use Mtc\Components\Languages\Http\ViewComposers\LanguageComposer;
use Mtc\Components\Languages\Language;
use Mtc\Core\Events\Admin\MenuLoading;
use Mtc\Core\Admin\Menu as AdminMenu;

/**
 * Connect the Menus Provider to Laravel
 *
 * @category Mtc\Components\Languages\Providers
 * @package  Mtc\Components\Languages
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class LanguageServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineRoutes();
        $this->defineEvents();

        View::composer('*layouts.admin', LanguageComposer::class);
        View::composer('*admin.builder.partials.*', LanguageComposer::class);
        View::composer('languages::public.language_switcher', LanguageComposer::class);
        View::composer('languages::admin.language_switcher', LanguageComposer::class);
    }

    /**
     * Define the resources for this package.
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'languages');
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'languages');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
        $this->publishes([
            __DIR__ . '/../../database/seeds/' => database_path('seeds')
        ], 'seeds');

    }

    protected function defineEvents()
    {
        // Admin Navigation Menu construct
        Event::listen(
            MenuLoading::class, function () {
            AdminMenu::addSubMenu(
                'general',
                'Manage Languages',
                'manage-languages',
                route('languages.admin.languages.index'),
                'languages');
        }
        );

        Event::listen('core.footer', function () {
            return view('languages::public.language_switcher');
        });
        Event::listen('admin.navigation_bar', function () {
            if (Language::query()->enabled()->count() > 1) {
                return view('languages::admin.language_switcher');
            }
        });
    }

    /**
     * Define the route model bindings.
     *
     * @return void
     */
    protected function defineRouteBindings()
    {
        Route::model('language', Language::class);
    }
    /**
     * Define the routes.
     *
     * @return void
     */
    protected function defineRoutes()
    {
        $this->defineRouteBindings();

        /**
         * If the routes have not been cached, we will include them in a route group
         * so that all of the routes will be conveniently registered to the given
         * controller namespace. After that we will load the Core routes file.
         */
        if (!$this->app->routesAreCached()) {
            Route::group(
                ['namespace' => 'Mtc\Components\Languages\Http\Controllers'],
                function ($router) {
                    $path = realpath(dirname(dirname(__DIR__ )). '/routes');
                    foreach (glob("{$path}/*.php") as $file) {
                        include $file;
                    }
                }
            );
        }
    }

}
