<?php
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Mtc\Components\Languages\Language;

/**
 * Languages Tests
 *
 * These are the tests for confirming the language
 * functionality is working without any unexpected issues
 *
 * @category Mtc\Components\Languages\Tests
 * @package Mtc\Components\Languages
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class LanguageTest extends \Tests\TestCase
{
    use DatabaseTransactions;


    public function testCreateLanguage()
    {
        $this->markTestIncomplete();
    }

    public function testUploadInvalidLanguageFile()
    {
        $this->markTestIncomplete();
    }


    public function testDownloadLanguageJsonFile()
    {
        $this->markTestIncomplete();
    }

    public function testUploadValidLanguageFile()
    {
        $this->markTestIncomplete();
    }

    public function testDeleteLanguage()
    {
        $this->markTestIncomplete();
    }

    public function testSwitchLanguage()
    {
        if (Language::query()->enabled()->count() < 2) {
            $this->markTestSkipped('Only one language enabled');
        }

        $this->markTestIncomplete();
    }

    /**
     * Test that translations are retrieved for a language
     */
    public function testGetTranslationsForLanguage()
    {
        $language = Language::query()->enabled()->first();
        $translations = collect($language->getTranslations());
        $this->assertTrue($translations->isNotEmpty());
    }

    /**
     * Test that flat translations are retrieved for a language
     * Also ensure that flat map is single level and not nested
     */
    public function testLanguageFlatTranslationsAreFlat()
    {
        $language = Language::query()->enabled()->first();
        $flat_translations = collect($language->getFlatTranslations())
            ->each(function ($entry) {
                if (!is_string($entry)) {
                    $this->fail('Flat List has non-string element');
                }
            });

        $this->assertTrue($flat_translations->isNotEmpty());
    }

    /**
     * Test that url for JS translations works and returns correct status code
     */
    public function testLanguageJsonUrlWorks()
    {
        $this->get(route('language_json'))
            ->assertStatus(200);
    }

}
