const elixir = require('laravel-elixir');

require('laravel-elixir-vue-2');

/*
 |--------------------------------------------------------------------------
 | Elixir Asset Management
 |--------------------------------------------------------------------------
 |
 | Elixir provides a clean, fluent API for defining some basic Gulp tasks
 | for your Laravel application. By default, we are compiling the Sass
 | file for our application, as well as publishing vendor resources.
 |
 */

elixir(mix => {

    mix.less('app.less')
       .webpack('app.js')
       .version(['js/app.js', 'css/app.css']);

    // Require --all to be passed to copy and create admin CSS/JS
    var argv = require('yargs').argv;
    if (argv.all) {
        mix.copy('node_modules/bootstrap-sass/assets/fonts/bootstrap', 'public/fonts/bootstrap')
           .copy('vendor/mtc/core/resources/fonts', 'public/fonts/core')
           .sass('admin.scss')
           .webpack('admin.js');
    }
});
