# Laracore

Based off of Laravel 5.3

See this wiki: http://wiki.mtcmedia.co.uk/index.php?title=Category:Laracore

## Contribution

Before submitting a pull request or developing new features or changes, please add a [Feature Request](http://frs.mtcmedia.co.uk/features) and wait for this to be approved before action. There are also feature requests in the system under the 'Laracore' products welcome to be picked up - just let us know!

## Installation

Watch the introduction/install here: https://www.youtube.com/watch?v=zh7GL3Q8zrc

Ensure you have your account on PHP 7 with the following extensions enabled:

* dom
* gd
* json
* mbstring
* mcrypt
* mysqlnd
* pdo
* pdo_mysql
* pdo_sqlite
* phar
* soap
* sockets
* wddx
* xmlreader
* xmlrpc
* xmlwriter
* xsl
* zip

The installation for this follows Laravel.

* Run `composer install` to get all required assets.
* Enter your MySQL details into `.env`.
* Run `php artisan migrate --seed` on the terminal.
    * This will create the base tables as well as seed base data.

### Seeding Products + Taxonomy (Category) Data.

By default this isn't included but can be run with the following commands.

```bash
# Creates all Google Shopping categories and NASA Leaders
php artisan db:seed --class="TaxonomySeeder"
# Creates products tied to Google Shopping categories (custom number prompted)
php artisan db:seed --class="ProductSeeder"
```

Please note adding these will take some time.

## Admin Access

The admin area is accessible via the /admin URL. You are able to login by using your project system details.

## Components

Plugins/Modules have been renamed to 'Components' in this release, marking a change of terminology. Each one presently resides in the `/components` folder but in future may be moved to `/vendor`, brought in with Composer.

Our hope would be that components are built with reuse in mind, and in cases where a component needs extensively changed to work as required for a particular case, that component is forked and used in the same manner to ensure updates are still available.

Component infrastructure is being evaluated to ensure best performance and upgradability.

## 3rd Party

We are currently using several 3rd party libraries:

* rachidlaasri/laravel-installer (may be ditched, to be decided)
* zizaco/entrust (Role based permissions, to be fully integrated)
* baum/baum (Providing model support for nested sets)
* barryvdh/laravel-debugbar (Debug bar for development environments)
* teamtnt/laravel-scout-tntsearch-driver (Laravel Scout Driver for text-based search)
* algolia/algoliasearch-client-php (Laravel Scout Driver for text-based search)
* elasticsearch/elasticsearch (Laravel Scout Driver for text-based search)
* league/csv (Easy as pie CSV parsing library)
* guzzlehttp/guzzle (HTTP request library)

## Help / I'm getting errors

Due to the various version of composer and node installed across servers you may encounter some errors while running `composer install`.  
Try some of the below.

###  I'm seeing errors about node and sass. ###

Try running `npm install node-sass`

### I'm getting an error in the browser about stylesheets not in the asset() path. ###

Try running `php artisan vendor:publish` from the project root, then `gulp`

### I'm getting an error about `forge` not being able to access stuff ###

Ensure the `.env` file exists (Copy `.env.example` as a base if needed), and that you have set you DB details correctly