# Laracore

Based off of Laravel 5.3

See this wiki: http://wiki.mtcmedia.co.uk/index.php?title=Category:Laracore

## Contribution

Before submitting a pull request or developing new features or changes, please add a [Feature Request](http://frs.mtcmedia.co.uk/features) and wait for this to be approved before action. There are also feature requests in the system under the 'Laracore' products welcome to be picked up - just let us know!

## Installation

Watch the introduction/install here: https://www.youtube.com/watch?v=zh7GL3Q8zrc

The installation for this follows Laravel.

* Copy `.env.example` to `.env`
* Run `composer install` to get all required assets.
* Run `php artisan key:generate` on the terminal.
* Enter your MySQL details into `.env`.
* Publish any assets needed for each component with `php artisan vendor:publish`
* Run `php artisan migrate --seed` on the terminal.
    * This will create the base tables as well as seed base data.

### Seeding Products + Taxonomy (Category) Data.

By default this isn't included but can be run with the following commands.

```bash
# Creates all Google Shopping categories and NASA Leaders
php artisan db:seed --class="TaxonomySeeder"
# Creates products tied to Google Shopping categories (custom number prompted)
php artisan db:seed --class="ProductSeeder"
```

Please note adding these will take some time.

## Admin Access

The admin area is accessible via the /admin URL. You are able to login by using your project system details.

## Components

Plugins/Modules have been renamed to 'Components' in this release, marking a change of terminology. Each one presently resides in the `/components` folder but in future may be moved to `/vendor`, brought in with Composer.

Our hope would be that components are built with reuse in mind, and in cases where a component needs extensively changed to work as required for a particular case, that component is forked and used in the same manner to ensure updates are still available.

Component infrastructure is being evaluated to ensure best performance and upgradability.

## 3rd Party

We are currently using several 3rd party libraries:

* rachidlaasri/laravel-installer (may be ditched, to be decided)
* zizaco/entrust (Role based permissions, to be fully integrated)
* baum/baum (Providing model support for nested sets)
* barryvdh/laravel-debugbar (Debug bar for development environments)
* teamtnt/laravel-scout-tntsearch-driver (Laravel Scout Driver for text-based search)
* algolia/algoliasearch-client-php (Laravel Scout Driver for text-based search)
* elasticsearch/elasticsearch (Laravel Scout Driver for text-based search)
* league/csv (Easy as pie CSV parsing library)
* guzzlehttp/guzzle (HTTP request library)

## Roadmap / Goals

The specific goal/dealine is for a basic ecommerce by February 2017. A full roadmap will be available soon, with the potential for more open development in the very near future.