<?php

namespace Mtc\Media\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Mtc\Media\Media;

/**
 * Connect the Media Provider to Laravel
 *
 * @category Mtc\Media\Providers
 * @package  Mtc\Media
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class MediaServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineRoutes();
    }


    /**
     * Define the resources for this package.
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
        $this->loadTranslationsFrom(__DIR__ . '/../..//resources/lang', 'media');
    }

    /**
     * Define the route model bindings.
     *
     * @return void
     */
    protected function defineRouteBindings()
    {
        Route::model('media', Media::class);
    }

    /**
     * Define the routes.
     *
     * @return void
     */
    protected function defineRoutes()
    {
        $this->defineRouteBindings();

        /**
         * If the routes have not been cached, we will include them in a route group
         * so that all of the routes will be conveniently registered to the given
         * controller namespace. After that we will load the Core routes file.
         */
        if (!$this->app->routesAreCached()) {
            Route::group(
                ['namespace' => 'Mtc\Media\Http\Controllers'],
                function ($router) {
                    $path = dirname(__DIR__, 2) . '/routes';
                    foreach (glob("{$path}/*.php") as $file) {
                        include $file;
                    }
                }
            );
        }
    }

}
