<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method. Build something great!
 *
 * PHP Version 7
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

use \Illuminate\Routing\Router;

/**
 * @var Router $router
 */

$router->group([
    'middleware' => ['web'],
], function (Router $router) {
    // The storage path must match what is defined in config.filesystems.disks.public.root
    $router->get('storage/{storage_file}', MediaController::class . '@show')->where('storage_file', '[A-Za-z0-9\.\-_\/]+');
    $router->resource('media', MediaController::class, [
        'only' => [
            'show',
            'store'
        ]
    ]);

    /*
     * Admin Requests
     */
    $router->group(
        [
            'prefix' => 'admin/media',
            'middleware' => ['auth', 'permission:admin'],
            'as' => 'media.admin.'
        ],
        function (Router $router) {
            $router->post('update_meta', Admin\MediaController::class . '@updateMeta')->name('update_meta');
            $router->post('update_order', Admin\MediaController::class . '@changeOrder')->name('update_order');
            $router->get('list', Admin\MediaController::class . '@list')->name('list');
            $router->post('upload', Admin\MediaController::class . '@upload')->name('upload');
            $router->resource('', Admin\MediaController::class);

        }
    );

});
