<?php
/**
 * Menu Seeder
 *
 * PHP Version 7
 *
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
use Illuminate\Database\Seeder;
use Mtc\Menus\Menu;

/**
 * Menu Seeder
 * Seed the DB with default menus - Primary and footer menu
 *
 * PHP Version 7
 *
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class MenuSeeder extends Seeder
{
    protected $factory = null;

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $seed_structure = [
            'Main Navigation' => [
                'Home' => '/',
                'About Us' => '/about',
                'New In' => '/browse',
                'Blog' => '/blog',
                'Contact Us' => '/contact'
            ],
            'Footer' => [
                'Shop' => [
                    'Tees' => '/browse',
                    'Shoes' => '/browse',
                    'Outerwear' => '/browse',
                    'Jeans' => '/browse',
                    'Outlet' => '/browse',
                ],
                'Our Company' => [
                    'About' => '/about',
                    'History' => '/history',
                    'Team' => '/team'
                ],
                'Customer Service' => [
                    'Delivery' => '/customer-service/delivery',
                    'Returns' => '/customer-service/returns',
                    'Terms' => '/customer-service/terms',
                    'Contact Us' => '/contact',
                ]
            ]
        ];
        // There are 22 menu items defined in the array above
        $amount = 22;
        $bar = $this->command->getOutput()->createProgressBar($amount);

        $this->recursiveSeed($seed_structure, $bar);

        $bar->finish();
    }

    /**
     * Recursively seed menu structure
     *
     * @param array $menu_level menu structure to implement
     * @param mixed $bar progress bar
     * @param null|Menu $parent Parent object
     */
    private function recursiveSeed($menu_level, $bar, $parent = null)
    {
        foreach ($menu_level as $menu_name => $menu_item) {
            // If this is a parent item without url
            if (is_array($menu_item)) {

                if ($parent) {
                    $menu = $parent->children()->create([
                        'title' => $menu_name,
                        'type' => 'Mtc\Menus\Menu'
                    ]);
                } else {
                    $menu = Menu::create([
                        'title' => $menu_name,
                        'type' => 'Mtc\Menus\Menu'
                    ]);
                }

                // Menu without url
                $this->recursiveSeed($menu_item, $bar, $menu);
            } else {
                // Menu with url
                if ($parent) {
                    $parent->children()->create([
                        'title' => $menu_name,
                        'url' => $menu_item,
                        'type' => 'Mtc\Menus\Menu'
                    ]);
                } else {
                    Menu::create([
                        'title' => $menu_name,
                        'url' => $menu_item,
                        'type' => 'Mtc\Menus\Menu'
                    ]);
                }
            }
            $bar->advance();
        }
    }

}
