<?php
/**
 * Menu Contract
 *
 * PHP Version 7
 *
 * @category Mtc\Menus\Contracts
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Menus\Contracts;

use Illuminate\Http\Request;

/**
 * This interface defines the necessary methods for building a Menu
 *
 * @category Mtc\Menus\Contracts
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
interface MenuContract
{
    /**
     * Run a search on the incoming request.
     *
     * @param \Illuminate\Eloquent\Query\Builder $query   Query Builder
     * @param Request                           $request Incoming search request
     *
     * @return \Illuminate\Eloquent\Query\Builder
     */
    public function scopeBuildSearch($query, Request $request);
}
