@extends('core::layouts.admin')

@section('title',  'Manage ' . ucfirst($title))

@section('content')

    @include('core::admin.builder.partials.tabs')

    <form method="POST" action="{{ $form_action }}">

        <div class="col-md-6">
            <div class="well">
                <h4>{{ trans('Manage Menu assignment') }}</h4>
                @foreach ($locations as $location)
                    <div class="form-group">
                        <label for="location_{{ $location->id }}">
                            {{ $location->title }}
                        </label>
                        <select name="location[{{ $location->id }}]"
                                class="form-control">
                            <option value="0">
                                {{ trans('Choose Menu') }}
                            </option>
                            @foreach($menus as $menu)
                                <option value="{{ $menu->id }}"
                                        {{ $location->menu && $menu->id == $location->menu->id ? 'selected' : '' }}>
                                    {{ $menu->title }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                @endforeach
                <button type="submit"
                        name="action"
                        value="update"
                        class="btn btn-success"
                >Save
                </button>
                <div class="pull-right">
                    <a class="btn btn-default" href="#top">Back to Top</a>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="well">
                <h4>{{ trans('Manage Menu Locations') }}</h4>
                {{--//TODO: Make menu locations dynamically pulled from templates--}}
                <div class="form-group">
                    <label for="new_title">
                        {{ trans('Title') }}
                    </label>
                    <input type="text"
                           name="new[title]"
                           value="{{ Request::old('new[title]') }}"
                           class="form-control"/>
                </div>
                <div class="form-group">
                    <label for="new_location_tag">
                        {{ trans('Location Tag') }}
                    </label>
                    <input type="text"
                           name="new[location]"
                           value="{{ Request::old('new[location]') }}"
                           class="form-control"/>
                </div>
                <button type="submit"
                        name="action"
                        value="add_new"
                        class="btn btn-success">
                    Save
                </button>
                <div class="pull-right">
                    <a class="btn btn-default" href="#top">Back to Top</a>
                </div>
            </div>
        </div>

        {{ method_field($form_method) }}
        {{ csrf_field() }}
    </form>
@endsection
