@extends('core::layouts.admin')

@section('title',  'Manage ' . ucfirst($title))

@section('content')

    @include('core::admin.builder.partials.tabs')

    <menu-builder inline-template
                  parent-in="{{ $item->id }}"
                  action="{{ $form_action }}"
                  fetch-action="{{ $fetch_action }}"
                  visible-tree="{{ json_encode($visible_tree) }}">
        <form method="POST" action="{{ $form_action }}">

            @if (!empty($item->id))
                <div class="row">
                    <div class="col-md-4">
                        @include('core::admin.builder.partials.node')

                        <div class="well" v-cloak>
                            @foreach ($sections as $section_name => $section)
                                @include('menus::admin.menus.partials.section')
                            @endforeach
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="well menuStructure" v-cloak>
                            <h4>Menu items</h4>
                            @include('menus::admin.menus.partials.structure', ['element' => $item])
                        </div>
                    </div>
                </div>
            @else
                @include('core::admin.builder.partials.node')
            @endif
            <div class="well well-sm">
                <button type="submit"
                        class="btn btn-success"
                >Save</button>
                <div class="pull-right">
                    <a class="btn btn-default" href="#top">Back to Top</a>
                </div>
            </div>

            {{ method_field($form_method) }}
            {{ csrf_field() }}
        </form>
    </menu-builder>
@endsection
