<div class="section">
    <h4 class="actionable"
        @click="setActiveSection('{{ addslashes($section['class']) }}')">
        <span :class="'glyphicon glyphicon-' + (active_section == '{{ addslashes($section['class']) }}' ? 'minus' : 'plus' )"></span>
        {{ $section_name }}
    </h4>
    <div v-if="active_section == '{{ addslashes($section['class']) }}'">
        <input type="hidden"
               v-model="update_fields.id"
               name="new[{{ $section['class'] }}][id]"/>
        @foreach ($section['fields'] as $name => $field)
            <div class="form-group">
                @if ($field['type'] !== 'hidden')
                    <label for="{{ str_slug($section_name . '_' . $name, '_') }}">
                        {{ $field['name'] }}
                    </label>
                @endif
                @if (in_array($field['type'], ['text', 'hidden']))
                    <input type="{{ $field['type'] }}"
                           v-model="update_fields.{{ $name }}"
                           name="new[{{ $section['class'] }}][{{ $name }}]"
                           id="{{ str_slug($section_name . '_' . $name, '_') }}"
                           class="form-control" />
                @elseif ($field['type'] === 'vue-component')
                    <{{ $field['component_name'] }}
                        @foreach ($field['props'] as $key => $prop)
                            {{ $key }}="{{ $prop }}"
                        @endforeach
                    ></{{ $field['component_name'] }}>
                @endif
            </div>
        @endforeach
    </div>
</div>