<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method.
 *
 * PHP Version 7
 *
 * @category Mtc\Menus
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */


$router->group(
    [
        'prefix' => 'admin',
        'middleware' => ['web', 'auth', 'permission:admin'],
        'as' => 'menus.admin.'
    ],
    function($router) {
        $router->resource('menus', Admin\MenuController::class);
        $router->resource('locations', Admin\LocationController::class);
        $router->post('menus/{menu}', Admin\MenuController::class . '@storeRequest')
            ->name('menus.storeRequest');
    }
);