<?php
/**
 * Class GetMenuSections
 *
 * @category Mtc\Menus\Events
 * @package Mtc\Menus
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Menus\Events\Admin;

use Mtc\Menus\Menu;

/**
 * Class GetMenuSections
 *
 * This event class is called upon Menu edit.
 * Event allows adding in Menu sections.
 *
 * @category Mtc\Menus\Events
 * @package Mtc\Menus
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class GetMenuSections
{
    /**
     * @var Menu $menu event Menu
     */
    public $menu;

    /**
     * GetMenuSections constructor.
     *
     * @param Menu $menu
     */
    public function __construct(Menu $menu)
    {
        $this->menu = $menu;
    }
}