<?php
/**
 * Custom Menu Section event
 *
 * PHP Version 7
 *
 * @category Mtc\Menus\Listeners
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Menus\Listeners;

use Mtc\Menus\Events\Admin\GetMenuSections;

/**
 * Retrieve custom Menu sections for Navigation management
 *
 * @category Mtc\Menus\Listeners
 * @package  Mtc\Menus
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomMenuSection
{
    /**
     * Handle the event.
     * Return supported menu types as a structured array.
     *
     * @param  GetMenuSections $event
     * @return array
     */
    public function handle(GetMenuSections $event)
    {
        return [
            'Custom Link' => [
                'type' => 'fields',
                'class' => 'Mtc\Menus\Menu',
                'fields' => [
                    'title' => [
                        'type' => 'text',
                        'name' => trans('Title')
                    ],
                    'url' => [
                        'type' => 'text',
                        'name' => trans('Link')
                    ]
                ]
            ],
        ];
    }
}